
#ifndef _RF_PARAMETER_H_
#define _RF_PARAMETER_H_

#include	"ht32.h"
#include "bc3603.h"







// <<< Use Configuration Wizard in Context Menu >>>

/* --------------------------------- Crystal Tune --------------------------------- */
//	<h> RF Crystal C-Load Tune
	//	<o> Coarse Tune<0-3>
	#define  _CYL_COARSE_TUNE_				(1)
	//	<o> Fine Tune<00-31>
	#define  _CYL_FINE_TUNE_					(3)
//	</h>


/* ------------------------- Frequency & Power & DataRate ------------------------- */
//	<h> RF Parameter Configuration
	//	<h> RF Frequency
			//	<o> Frequency Band
			//				<0=> 315MHz
			//				<1=> 433MHz
			//				<2=> 470MHz
			//				<3=> 868MHz
			//				<4=> 915MHz
			#define  _RF_FREQ_BAND_						(1)
			//	<o> Frequency(Unit:Hz) <300000000-999000000>
			#define  _RF_FREQUENCY_						(433920000UL)
	//	</h>
	//	<o> RF Tx Power
	//				<0=> 0dBm
	//				<1=> 10dBm
	//				<2=> 13dBm
	//				<3=> 17dBm
	//				<4=> 19dBm	
	#define  _RF_TX_POWER_						(1)
	//	<o> RF Data Rate
	//				<0=> 2KBps
	//				<1=> 10KBps
	//				<2=> 50KBps
	//				<3=> 125KBps
	//				<4=> 250KBps
	#define  _RF_DATA_RATE_						(2)
//	</h>


/* ------------------------- Packet Format Configuration ------------------------- */
//	<h> RF Packet Format Configuration
	//	<h> Tx Preamble Pattern
			//	<o> Type Select
			//				<0=> SYNCWORD MSB
			//				<1=> 1Byte Pattern
			//				<3=> 2Byte Pattern
			#define	_TX_PREAMBLE_CLASS_				(1)
			//	<o> Pattern Value<0x0000-0xFFFF>
			#define	_TX_PREAMBLE_PATTERN_			(0xAAAA)
			//	<o> Length<1-255>
			#define	_TX_PREAMBLE_LENGTH_			(4)
	//	</h>
	//	<o> Payload Data Length<1-64>
	#define	_RECEIVER_PDLEN_					(64)
	//	<h> SYNC Pattern
			//	<o> Syncword Field Width
			//				<1=> 1Byte
			//				<2=> 2Bytes
			//				<3=> 3Bytes
			//				<4=> 4Bytes
			//				<5=> 5Bytes
			//				<6=> 6Bytes
			//				<7=> 7Bytes
			//				<8=> 8Bytes
			#define  _SYNCWORD_WIDTH_ 				(6)
			//	<o> SYNC_L Value<0x00000000-0xFFFFFFFF>
			#define	_SYNCWORD_LOW_						(0xB8CB2B05)
			//	<o> SYNC_H Value<0x00000000-0xFFFFFFFF>
			#define	_SYNCWORD_HIGH_						(0x753DE91C)
			//	<q> Syncword is calculated by BCH
			#define  _SYNCWORD_BCH_				(1)
	//	</h>
	//		<q> Trailer Field Enable
	#define  _TRAILER_FIELD_ 					(0)
	//	<e> Head Field Enable
	//		<o> Head Width
	//				<i> Default:8Bits
	//				<1=> 8Bits
	//				<2=> 16Bits
	#define  _HEAD_WIDTH_ 						(0)
	//	<o> Head Address<00000-16383>
	#define	_HEAD_ADDRESS_						(0x00)
	#if ((_HEAD_WIDTH_ == 1) && (_HEAD_ADDRESS_ > 0x3F))
		#error "Head address issue: Length field must be matched with selected!"
	#endif
	#if ((_HEAD_WIDTH_ == 2) && (_HEAD_ADDRESS_ > 0x0FFF))
		#error "Head address issue: Length field must be matched with selected!"
	#endif
	//	</e>
	//		<q> Length Field Enable
	#define  _LENGTH_FIELD_ 					(0)
	#if ((_LENGTH_FIELD_ == 1)&&(_RECEIVER_PDLEN_ == 64))
		#error "Payload length issue: Payload length field must be less than 64 when length field enable!"
	#endif
	//	<e> CRC Field Enable
			//	<o> Format
			//				<i> Default:CCIT-16
			//				<1=> CCIT-16
			//				<2=> IBC-16
			#define  _CRC_FIELD_ 							(1)
			//	<q> Inverted Enable
			#define  _CRC_INVERTED_						(0)

			//	<o> Byte Transmission order
			//			<0=> High Byte First
			//			<1=> Low Byte First
			#define	_CRC_BYTE_ORDER_					(0)

			//	<o> Bit Transmission order
			//			<0=> MSB First
			//			<1=> LSB First
			#define	_CRC_BIT_ORDER_						(0)

			//	<o> CRC Seed<0x0000-0xFFFF>
			#define	_CRC_SEED_								(0xFFFF)	
	//	</e>
//	</h>
//	<h> RF Packet Code Configuration
	//	<q> Manchester Code Enable
	#define  _MANCHESTER_CODE_				(0)
	//	<q> Hamming Code(FEC) Enable
	#define  _HAMMING_CODE_						(0)
	//	<q> Examine Head Address Enable
	#define  _EXAMINE_PLHAC_					(0)
	//	<e> Whitening Code Enable
	#define  _WHITENING_CODE_					(0)
			//	<o> Format
			//				<i> Default:360X			
			//				<1=> 360X
			//				<2=> PN7
			//				<3=> PN9-CCIT
			//				<4=> PN9-IBM
			#if _WHITENING_CODE_
			#define  _WHITENING_CODEC_			(1)
			#else
			#define  _WHITENING_CODEC_			(0)
			#endif
			//	<o> Whitening Seed(12bit)<0x000-0x1FF>
			#define  _WHITENING_SEED_				(0x3B)
	//	</e>
//	</h>
//	<h> Receiver Parameter Configuration
	//	<q> Continue Mode Enable
	#define	_RECEIVER_MODE_						(0)
	#if ((_RECEIVER_MODE_ != 0) && (_LENGTH_FIELD_ == 0))
		#error "Receiver continue mode issue: Length field must be enable!"
	#endif
	#if ((_AUTOMATIC_ACK_ != 0) && ((_HEAD_WIDTH_ == 0) || (_LENGTH_FIELD_ == 0)))
		#error "Automatic acknowledge issue: Head field and length field must be enable!"
	#endif
//	</h>



//	<h>ATR&ARK Configuration
	//	<o> ATR/ARK Time unit
	//				<0=> 250us
	//				<1=> 1ms
	#define	_ATRK_TIME_UNIT_				(0)
	//	<e> Automatic Acknowledge(ARK) Enable
	#define  _AUTOMATIC_ACK_					(0)
				//		<o> Auto-ACK RX waiting time (unit:ms)
				#define	_ARKRXAP_TIME_					(10)
				#if _ATRK_TIME_UNIT_
					#define	_ARKRXAP_VALUE_					(_ARKRXAP_TIME_)
					#if (_ARKRXAP_VALUE_ > 0x3FF)
						#error "ARKRXAP value out of range!"
					#endif
				#else
					#define	_ARKRXAP_VALUE_					(_ARKRXAP_TIME_*4)
					#if (_ARKRXAP_VALUE_ > 0x3FF)
						#error "ARKRXAP value out of range!"
					#endif
				#endif	
				//		<o> Auto resend times<0-15>
				#define	_ARS_TIMES_							(3)
	//	</e>
	//	<e> Automatic TX/RX(ATR) Enable
	#define  _AUTOMATIC_ATR_					(0)
			//	<o> ATR mode selection
			//				<0=> WOT single
			//				<1=> WOR single
			//				<2=> WTM single
			//				<4=> WOT continue
			//				<5=> WOR continue
			//				<6=> WTM continue
			#define	_ATR_MD_SEL_						(5)
			//	<o> ATR clock frequency selection
			//				<0=> 32768Hz
			//				<1=> 8192Hz
			//				<2=> 4096Hz
			//				<3=> 2048Hz
			#define	_ATR_CLK_SEL_						(2)
			//	<o> ATR cycle period (unit:ms)
			#define	_ATR_CYC_								(2000)
			#if _ATR_CLK_SEL_==0
				#define	_ATR_CYC__VALUE_			((_ATR_CYC_*32768UL)/1000UL)
				#if ((_ATR_CYC__VALUE_-1) > 0xFFFF)
					#error "ATRCYC value out of range!"
				#endif
			#endif
			#if _ATR_CLK_SEL_==1
				#define	_ATR_CYC__VALUE_			((_ATR_CYC_*8192UL)/1000UL)
				#if ((_ATR_CYC__VALUE_-1) > 0xFFFF)
					#error "ATRCYC value out of range!"
				#endif
			#endif
			#if _ATR_CLK_SEL_==2
				#define	_ATR_CYC__VALUE_			((_ATR_CYC_*4096UL)/1000UL)
				#if ((_ATR_CYC__VALUE_-1) > 0xFFFF)
					#error "ATRCYC value out of range!"
				#endif
			#endif
			#if _ATR_CLK_SEL_==3
				#define	_ATR_CYC__VALUE_			((_ATR_CYC_*2048UL)/1000UL)
				#if ((_ATR_CYC__VALUE_-1) > 0xFFFF)
					#error "ATRCYC value out of range!"
				#endif
			#endif
			//		<o> ATR RX active period time (unit:us)
			#define	_ATRRXAP_TIME_					(1000)
			#if _ATRK_TIME_UNIT_
				#define	_ATRRXAP_VALUE_				(_ATRRXAP_TIME_/250UL)
				#if ((_ATRRXAP_VALUE_-1) > 0x3FF)
					#error "ATRRXAP value out of range!"
				#endif
			#else
				#define	_ATRRXAP_VALUE_				(_ATRRXAP_TIME_/1000UL)
				#if ((_ATRRXAP_VALUE_-1) > 0x3FF)
					#error "ATRRXAP value out of range!"
				#endif
			#endif
			//		<o> ATR RX active extend period time (unit:ms)
			#define	_ATRRXEP_TIME_					(50)
			#if _ATRK_TIME_UNIT_
				#define	_ATRRXE_VALUE_				(_ATRRXEP_TIME_)
				#if ((_ATRRXE_VALUE_-1) > 0xFFFF)
					#error "ATRRXAP value out of range!"
				#endif
			#else
				#define	_ATRRXE_VALUE_				(_ATRRXEP_TIME_*4)
				#if ((_ATRRXE_VALUE_-1) > 0xFFFF)
					#error "ATRRXAP value out of range!"
				#endif
			#endif
	//	</e>
//	</h>


// <<< end of configuration section >>>

#endif	//_RF_PARAMETER_H_
